<?php

//error_reporting(E_ALL);

session_name('sid');
session_start();

define('ST', microtime(true));
define('PATH', 'http://' . $_SERVER['HTTP_HOST'] . dirname($_SERVER['PHP_SELF']) . '/');
define('SID', constant('sid'));

include('system/config.inc.php');
include('system/func_active.inc.php');

# Для тесторования
error_reporting(E_ALL);
ini_set('display_errors', true);
ini_set('html_errors', true);
ini_set('error_reporting', E_ALL);

// Получаем браузер и айпи юзера
$ua = '?#?';

if( !empty($_SERVER['HTTP_X_OPERAMINI_PHONE_UA']) )
{
	$ua = '(OM) ' . clean($_SERVER['HTTP_X_OPERAMINI_PHONE_UA'], 100, '?#?');
}
elseif( !empty($_SERVER['HTTP_USER_AGENT']) )
{
	$ua = clean($_SERVER['HTTP_USER_AGENT'], 100, '?#?');
}

$ip = $_SERVER['REMOTE_ADDR'];

// Присваиваем куки id юзеру
if( !isset($_COOKIE['id']) )
{
	setcookie('id', md5(uniqid(rand() , 1)), time() + 31536000);
}

// Достаем из кукисов данные юзера
$_COOKIE['name'] = ( empty($_COOKIE['name']) ? '' : clean($_COOKIE['name'], Q_NAME) );
$_COOKIE['email'] = ( empty($_COOKIE['email']) ? '' : clean($_COOKIE['email'], 20) );
$_COOKIE['icq'] = ( empty($_COOKIE['icq']) ? '' : clean($_COOKIE['icq'], 10) );
$_COOKIE['id'] = ( empty($_COOKIE['id']) ? '' : clean($_COOKIE['id'], 32) );

// Выход и авторизация
if( $auth = isset($_SESSION['admin_login']) )
{
	if( isset($_GET['exit']) || $_SESSION['admin_auth_ip'] != substr($ip, 0, 3) )
	{
		session_destroy();

		setcookie('login', '');
		setcookie('password', '');

		$auth = false;
	}
}
elseif( isset($_REQUEST['login'], $_REQUEST['password']) && is_string($_REQUEST['login']) && is_string($_REQUEST['password']) )
{
	foreach( $admin as $v )
	{
		$admin_name[] = strtok($v, '|');
	}

	$k = array_search($_REQUEST['login'], $admin_name);

	if( !isset($_COOKIE['login'], $_COOKIE['password']) )
	{
		$_REQUEST['password'] = md5(md5($_REQUEST['password']));
	}

	if( $k !== false && $_REQUEST['password'] == $password )
	{
		$admin = explode('|', $admin[$k]);

		$_SESSION['admin_login'] = $admin[0];
		$_SESSION['admin_email'] = $admin[1];
		$_SESSION['admin_icq'] = $admin[2];
		$_SESSION['admin_auth_ip'] = substr($ip, 0, 3);

		if( isset($_GET['cookie']) )
		{
			setcookie('login', $admin[0], time() + 31536000, '', $_SERVER['HTTP_HOST']);
			setcookie('password', $password, time() + 31536000, '', $_SERVER['HTTP_HOST']);
		}
		
		$auth = true;
	}
}

// Онлайн счетчик

$online = file('data/online.dat');
$cnt = count($online) - 1;
$new_online = true;
$time = time();

for( $i = 0; $i <= $cnt; $i++ )
{
	$o = explode('|', rtrim($online[$i]));

	if( $ip == $o[3] )
	{
		$online[$i] = $time + (ONLINE_TIME * 60) . '|' . ( $auth ? $_SESSION['admin_login'] : $_COOKIE['name'] ) . "|$ua|$ip\r\n";
		$new_online = false;
	}
	elseif( $time > $o[0] )
	{
		$online[$i] = '';
	}
}

if( $new_online )
{
	$online[] = $time + (ONLINE_TIME * 60) . '|' . ( $auth ? $_SESSION['admin_login'] : $_COOKIE['name'] ) . "|$ua|$ip\r\n";
}

puts('data/online.dat', implode($online), 'w');

// Заголовки и шапка

header('Content-type: application/xhtml+xml; charset=UTF-8');
header('Last-Modified: ' . gmdate('r') . ' GMT');
header('Cache-Control: post-check=0, pre-check=0', false);
header('Pragma: no-cache');

$header = '<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE html PUBLIC "-//WAPFORUM//DTD XHTML Mobile 1.0//EN" "http://www.wapforum.org/DTD/xhtml-mobile10.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta name="copyright" content="Powered by Jeey" />
<link rel="shortcut icon" type="image/x-icon" href="/favicon.ico" />
<link rel="stylesheet" type="text/css" href="style/style.css" />
<title>' . TITLE . '</title>
</head>
<body>
<div class="header">' . ( $auth ? 'Админ-панель <strong>[' . $_SESSION['admin_login'] . ']</strong>' : HEADER_TEXT ) . '</div>' . "\r\n";

// Страницы (для юзера)

if( !$auth )
{
    // Крепим новость
    $news=file_get_contents('data/news.dat');
    if($news!='')
        $header.='<div>'.$news.'</div>';

	if( isset($_GET['add']) ) // Страница добавления сообщения
	{
		// Вытаскиваем данные юзера

		$message = file('data/message.dat');
		$is_id = false;

		if( isset($_GET['id']) )
		{
			$_GET['id'] = (int) $_GET['id'];

			if( array_key_exists($_GET['id'], $message) )
			{
				$m = explode('|', rtrim($message[$_GET['id']]));
				$is_id = true;
			}
		}

		$error = '';

		if( isset($_POST['send'], $_SESSION['code']) )
		{
			$_POST['name'] = ( empty($_POST['name']) ? '' : clean($_POST['name'], Q_NAME) );
			$_POST['email'] = ( empty($_POST['email']) ? '' : clean($_POST['email'], 20) );
			$_POST['icq'] = ( empty($_POST['icq']) ? '' : clean($_POST['icq'], 10) );
			$_POST['text'] = ( empty($_POST['text']) ? '' : clean($_POST['text'], Q_TEXT) );
			$_POST['code'] = ( isset($_POST['code']) ? (int) $_POST['code'] : '' );

			// Сначала проверяем, не забанен ли юзер. Потом всё остальное

			if( preg_match('/' . preg_quote("1|$ip|$ua", '/') . ( $_COOKIE['id'] ? '|' . preg_quote('2|' . $_COOKIE['id'], '/') : '' ) . '|' . preg_quote("3|$ip", '/') . '/', file_get_contents('data/ban.dat')) )
			{
				$error.= '<div><span class="green">- Вы заблокированы и не можете добавлять сообщения!</span></div>';
			}
			else
			{
				foreach( $admin as $v )
				{
					$admin_name[] = strtok($v, '|');
				}

				if( !$_POST['name'] )
				{
					$error.= '<div>- Вы не ввели имя.</div>';
				}
				elseif( !preg_match('/[;,~!:@&\.\?\/\[\]\(\)\*\+\-=еёа-яa-z0-9]+/iu', $_POST['name']) )
				{
					$error.= '<div>- В имени обнаружены недопустимые символы.</div>';
				}
				elseif( in_array($_POST['name'], $admin_name) )
				{
					$error.= '<div><span class="green">- Нельзя писать от этого имени! Пожалуйста, придумайте себе другое.</span></div>';
				}

				if( $_POST['email'] && !preg_match('/^~?[\.\-a-zA-Z_]+@[\.\-a-zA-Z]+$/', $_POST['email']) )
				{
					$error.= '<div>- Вы ввели некорректный E-mail адрес.</div>';
				}

				if( $_POST['icq'] && !preg_match('/^~?[0-9]+$/', $_POST['icq']) )
				{
					$error.= '<div>- ICQ может содержать только цифры.</div>';
				}

				if( !$_POST['text'] )
				{
					$error.= '<div>- Вы не ввели текст.</div>';
				}

				if( !$_POST['code'] )
				{
					$error.= '<div>- Вы не ввели проверочный код.</div>';
				}
				elseif( $_POST['code'] != $_SESSION['code'] )
				{
					$error.= '<div>- Вы неверно ввели проверочный код.</div>';
				}

				unset($_SESSION['code']);
			}

			// Если все верно, приступаем к записи сообщения

			if( !$error )
			{
				// Загружаем файл с функциями

				include('system/func_not_active.inc.php');

				// Обрабатываем

				$_POST['text'] = bbcodesmile(str_replace("\r\n", '<br/>', $_POST['text']));

				// Транслитируем

				if( isset($_POST['tr_name']) )
				{
					$_POST['name'] = translate($_POST['name']);
				}

				if( isset($_POST['tr_text']) )
				{
					$_POST['text'] = translate($_POST['text']);
				}

				// Если пишем определённому юзеру, то добавляем его имя в начало текста

				if( $is_id )
				{
					$_POST['text'] = $m[1] . ', ' . $_POST['text'];
				}

				// Проверяем сообщение на одинаковость с последним сообщением

				if( $message )
				{
					$search = explode('|', end($message));

					if( $_POST['name'] == $search[1] && $_POST['text'] == $search[9] )
					{
						header('Location: ' . PATH . ( SID ? '?' . SID : '' ));
						exit;
					}
				}

				// Записываем данные юзера в куки

				setcookie('name', $_POST['name'], time() + 31536000);
				setcookie('email', $_POST['email'], time() + 31536000);
				setcookie('icq', $_POST['icq'], time() + 31536000);

				// Удалялка старых сообщений

				if( MAX_MESSAGE && count($message) >= MAX_MESSAGE )
				{
					$message[0] = '';
				}

                $_POST['text']=antimat($_POST['text']);

				// Записываем сообщение в файл

				$message[] = 'user|' . $_POST['name'] . '|' . date('j.m') . '|' . date('H:i') . '|' . $_POST['email'] . '|'. $_POST['icq'] . "|$ua|$ip|" . $_COOKIE['id'] . '|' . $_POST['text'] . "|||\r\n";

				puts('data/message.dat', implode($message), 'w');

				header('Location: ' . PATH . ( SID ? '?' . SID : '' ));
				exit;
			}
		}

		// Шапка

		echo $header . '<div class="top"><a href="?help' . ( $is_id ? '&amp;id=' . $_GET['id'] : '' ) . '">Помощь</a></div>' . "\r\n";
echo '<div class="b">Email и ICQ писать не объязательно</div>';

		// Выводим ошибки, если есть

		if( $error )
		{
			echo '<div class="b"><span class="red"><strong>Ошибка!</strong></span><br/>' . $error . '</div>' . "\r\n";
		}

		// Генерируем число для каптчи

		$_SESSION['code'] = rand(1000, 9999);

		// Форма ввода

		echo '<div class="a"><form action="?add' . ( $is_id ? '&amp;id=' . $_GET['id'] : '' ) . '" method="post"><fieldset>' . "\r\n",
		'Имя: [' . Q_NAME . ']<br /><input type="text" name="name" value="' . ( $error ? $_POST['name'] : $_COOKIE['name'] ) . '" maxlength="' . Q_NAME . '" class="texta" size="16" /><br /><input type="checkbox" name="tr_name" /> Транслит<br />' . "\r\n",
		'Email: [20]<br /><input type="text" name="email" value="' . ( $error ? $_POST['email'] : $_COOKIE['email'] ) . '" maxlength="20" class="text" size="16" /><br />' . "\r\n",
		'ICQ: [10]<br /><input type="text" name="icq" value="' . ( $error ? $_POST['icq'] : $_COOKIE['icq'] ) . '" maxlength="9" class="text" size="16" /><br />' . "\r\n",
		( $is_id ? '<strong>' . $m[1] . '</strong>,' : 'Текст:' ) . ' [' . Q_TEXT . ']<br /><textarea name="text" cols="15" rows="2" class="texta">' . ( $error ? $_POST['text'] : '' ) . '</textarea><br /><input type="checkbox" name="tr_text" /> Транслит<br />' . "\r\n",
		'<img src="code/code.php?' . rand(1000, 9999) . ( SID ? '&amp;' . SID : '' ) . '" alt="" width="65" height="25"/><br />Проверочное число:<br /><input type="text" name="code" maxlength="4" size="4" class="texta" /><br />' . "\r\n",
		'<input type="submit" name="send" value="Написать" class="submit" />' . "\r\n",
		'</fieldset></form></div>' . "\r\n";

		// Данные пользователя

		if( $is_id )
		{
			echo '<div class="b"><strong>Данные пользователя</strong><br />' . "\r\n",
			'<img src="style/email.gif" alt="Email" /> ' . ( $m[4] && $m[4]{0} != '~' ? $m[4] : 'Не указано' ) . '<br />' . "\r\n",
			'<img src="style/icq.gif" alt="ICQ" /> ' . ( $m[5] && $m[5]{0} != '~' ? $m[5] : 'Не указано' ) . '</div>' . "\r\n";
		}

		echo '<div class="bottom"><a href="./">Назад</a> • <a href="/">На главную</a></div>';
	}
	elseif( isset($_GET['help']) ) // Страница помощи
	{
		$_GET['id'] = ( isset($_GET['id']) ? '&amp;id=' . (int) $_GET['id'] : '' );

		echo $header;

		if( isset($_GET['smile']) ) // Страница смайлов
		{
			$smile = array_diff(array_map(create_function('$v', 'return substr($v, 0, -4);'), scandir('smile/')), array(''));
			rsort($smile);
			$all = count($smile);
			$page = ( isset($_GET['page']) ? (int) $_GET['page'] : 1 );
			$num_pages = ceil($all / Q_PSMILE);
			$start = $page * Q_PSMILE - Q_PSMILE;

			if( $page > $num_pages || $page < 1 )
			{
				$page = 1;
				$start = 0;
			}

			echo '<div class="top">Смайлы</div>' . "\r\n";

			// Выводим

			if( $all )
			{
				echo '<div class="a">' . "\r\n";

				for( $i = $all - $start - 1; $i >= $all - $start - Q_PSMILE && isset($smile[$i]); $i-- )
				{
					echo ':' . $smile[$i] . ': <img src="smile/' . $smile[$i] . '.gif" alt=":' . $smile[$i] . ':" /><br />' . "\r\n";
				}

				echo '</div>' . "\r\n";

				// Навигация

				echo '<div class="bottom">' . ( $num_pages >= 10 ? '<a href="?go&amp;back=' . $page . '">Стр.</a>' : 'Стр.' );

				for( $pr = '', $i = 1; $i <= $num_pages; $i++ )
				{
					echo $pr = (($i == 1 || $i == $num_pages || abs($i - $page) < 3) ? ($i == $page ? " [$i] " : ' <a href="./?help&amp;smile' . $_GET['id'] . '&amp;page=' . $i . '">' . $i . '</a> ') : (($pr == ' .. ' || $pr == '') ? '' : ' .. '));
				}
			}
			else
			{
				echo '<div class="a">Смайлов нет.</div>' . "\r\n",
				'<div class="bottom">Стр. [1]';
			}

			echo ' • <a href="?help' . $_GET['id'] . '">Назад</a> • <a href="./">В гостевую</a> • <a href="/">На главную</a></div>';
		}
		elseif( isset($_GET['bbcode']) ) // Страница ббкодов
		{
			echo '<div class="top">ББ коды</div>
            <div class="a">'.file_get_contents('data/bbcode.dat').'</div>
            <div class="bottom"><a href="?help' . $_GET['id'] . '">Назад</a> • <a href="./">В гостевую</a> • <a href="/">На главную</a></div>';
		}
		elseif( isset($_GET['translate']) ) // Страница с правилами транслита
		{
			echo '<div class="top">Правила транслита</div>
            <div class="a">'.file_get_contents('data/translit.dat').'</div>
            <div class="bottom"><a href="?help' . $_GET['id'] . '">Назад</a> • <a href="./">В гостевую</a> • <a href="/">На главную</a></div>';
		}
		else // Основная страница помощи
		{
			echo '<div class="top">Раздел помощи</div><div class="a">
            • <a href="?help&amp;smile' . $_GET['id'] . '">Смайлы</a><br />
            • <a href="?help&amp;bbcode' . $_GET['id'] . '">BB коды</a><br />
            • <a href="?help&amp;translate' . $_GET['id'] . '">Правила транслита</a><br />
            <br />'.file_get_contents('data/help.dat').'<div class="bottom"><a href="?add' . $_GET['id'] . '">Назад</a> • <a href="./">В гостевую</a> • <a href="/">На главную</a></div>';
		}
	}
	elseif( isset($_GET['go']) ) // Страница перехода на страницу (страница перехода на страницу... бгг)
	{
		echo $header . '<div class="top">Перейти на страницу</div>' . "\r\n",
		'<div class="a"><form action="" method="get"><fieldset>' . "\r\n",
		'Стр. <input type="text" name="page" size="4" class="texta" />' . "\r\n",
		'<input type="submit" value="Go" class="submit" />' . "\r\n",
		'</fieldset></form></div>' . "\r\n",
		'<div class="bottom"><a href="?page=' . ( isset($_GET['back']) ? (int) $_GET['back'] : 1 ) . '">Назад</a> • <a href="/">На главную</a></div>';
	}
	elseif( isset($_GET['site']) )
	{
		$_GET['site'] = str_replace('&amp;', '&', clean($_GET['site'], 500));

		echo $header . '<div class="top">Перейти</div>' . "\r\n",
		'<div class="a"><a href="' . $_GET['site'] . '">' . $_GET['site'] . '</a></div>' . "\r\n",
		'<div class="bottom"><a href="?page=' . ( isset($_GET['back']) ? (int) $_GET['back'] : 1 ) . '">Назад</a> • <a href="/">На главную</a></div>';
	}
	else // Главная
	{
		$message = file('data/message.dat');
		$all = count($message);
		$_GET['page'] = ( isset($_GET['page']) ? (int) $_GET['page'] : 1 );
		$num_pages = ceil($all / U_Q_MESSAGE);
		$start = $_GET['page'] * U_Q_MESSAGE - U_Q_MESSAGE;

		if( $_GET['page'] > $num_pages || $_GET['page'] < 1 )
		{
			$_GET['page'] = 1;
			$start = 0;
		}

		// Шапка

		echo $header . '<div class="sfon"><a href="?add">Добавить сообщение</a><br /></div><a href="http://gegas.ru/guestbook/rules.php"><span style="color: #FF0000;">Правила!</span></a><br/>' . "\r\n";

		// Выводим сообщения

		if( $all )
		{
			for( $i = $all - $start - 1; $i >= $all - $start - U_Q_MESSAGE && isset($message[$i]); $i-- )
			{
				$m = explode('|', rtrim($message[$i]));
				echo '<div class="' . ( $i % 2 == 0 ? 'a' : 'b' ) . '"><span class="' . $m[0] . '"><strong><a href="?add&amp;id=' . $i . '">' . $m[1] . '</a></strong></span> <span class="aa">' . today($m[2]) . ', ' . $m[3] . '</span><br />' . $m[9] . ( $m[10] ? '<div class="answer"><span class="red"><strong>Ответ</strong></span> <span class="aa">' . today($m[11]) . ', ' . $m[12] . '</span><br />' . $m[10] . '</div>' : '' ) . '</div>' . "\r\n";
			}

			// Навигация

			echo '<div class="bottom">' . ( $num_pages >= 10 ? '<a href="?go&amp;back=' . $_GET['page'] . '">Стр.</a>' : 'Стр.' );

			for( $pr = '', $i = 1; $i <= $num_pages; $i++ )
			{
				echo $pr = (($i == 1 || $i == $num_pages || abs($i - $_GET['page']) < 3) ? ($i == $_GET['page'] ? " [$i] " : ' <a href="?page=' . $i . '">' . $i . '</a> ') : (($pr == ' .. ' || $pr == '') ? '' : ' .. '));
			}
		}
		else
		{
			echo '<div class="a">Сообщений нет.</div>' . "\r\n",
			'<div class="bottom">Стр. [1]';
		}

		echo ' • <a href="/">На главную</a></div>';
	}

	// Ноги

	echo  "\r\n" . '<div class="footer">' . COPYRIGHT . '</div>' . "\r\n",
	'</body></html>' . "\r\n",
	'<!-- ' . round(microtime(true) - ST, 4) . ' -->';

	exit;
}

// Страницы (админ-панель)

if( isset($_GET['add']) ) // Страница добавления сообщения/ответа
{
	include('system/func_not_active.inc.php');

	$message = file('data/message.dat');
	$is_id = false;

	if( isset($_GET['id']) )
	{
		$_GET['id'] = (int) $_GET['id'];

		if( array_key_exists($_GET['id'], $message) )
		{
   $m = explode('|', rtrim($message[$_GET['id']]));
   $is_id = true;
  }
 }

 $_GET['back'] = ( isset($_GET['back']) ? (int) $_GET['back'] : 1 );

 if( isset($_POST['send']) )
 {
  if( empty($_POST['text']) )
  {
   $_POST['text'] = '';
  }
  else
  {
   $_POST['text'] = bbcodesmile(str_replace("\r\n", '<br/>', clean($_POST['text'], Q_TEXT)));

   if( isset($_POST['tr_text']) )
   {
    $_POST['text'] = translate($_POST['text']);
   }
  }

  // Если добавляем ответ админа

  if( $is_id )
  {
   $m[10] = & $_POST['text'];
   $m[11] = '';
   $m[12] = '';

   if( $_POST['text'] )
   {
    $m[11] = date('j.m');
    $m[12] = date('H:i');
   }

   $message[$_GET['id']] = implode('|',  $m) . "\r\n";

   puts('data/message.dat', implode($message), 'w');

   header('Location: ' . PATH . '?page=' . $_GET['back'] . ( SID ? '&' . SID : '' ));
   exit;
  }

  // Если пишем как обычное сообщение

  if( $_POST['text'] )
  {
   // Проверяем сообщение на одинаковость

   if( $message )
   {
    $search = explode('|', end($message));

    if( $_SESSION['admin_login'] == $search[1] && $_POST['text'] == $search[9] )
    {
     header('Location: ' . PATH . ( SID ? '?' . SID : '' ));
     exit;
    }
   }

   // Удалялка старых сообщений

   if( MAX_MESSAGE && count($message) >= MAX_MESSAGE )
   {
    $message[0] = '';
   }

   // Записываем сообщение в файл

   $message[] = 'admin|' . $_SESSION['admin_login'] . '|' . date('j.m') . '|' . date('H:i') . '|' . $_SESSION['admin_email'] . '|' . $_SESSION['admin_icq'] . '|' . $ua . '|' . $ip . '|' . $_COOKIE['id'] . '|' . $_POST['text'] . "|||\r\n";

   puts('data/message.dat', implode($message), 'w');

   header('Location: ' . PATH . ( SID ? '?' . SID : '' ));
   exit;
  }
 }

 // Выводим

 echo $header;

 if( $is_id ) // Если отвечаем на сообщение
 {
  echo '<div class="top"><a href="?help&amp;id=' . $_GET['id'] . '&amp;back=' . $_GET['back'] . '">Помощь</a></div>' . "\r\n",
  '<div class="a"><form action="?add&amp;id=' . $_GET['id'] . '&amp;back=' . $_GET['back'] . '" method="post"><fieldset>' . "\r\n",
  'Текст: [' . Q_TEXT . ']<br /><textarea name="text" cols="15" rows="2" class="text">' . edittext($m[10]) . '</textarea><br /><input type="checkbox" name="tr_text" /> Транслит<br />' . "\r\n",
  '<input type="submit" name="send" value="' . ( $m[10] ? 'Сохранить' : 'Ответить' ) . '" class="submit" /></fieldset></form></div>' . "\r\n",
  '<div class="b"><strong>' . $m[1] . '</strong><br />' . $m[9] . '<br />' . "\r\n",
  '<strong>Данные пользователя</strong> <a href="?edit&amp;id=' . $_GET['id'] . '">[Ред]</a><br />' . "\r\n",
  '<img src="style/email.gif" alt="" /> ' . ( $m[4] ? $m[4] : 'Не указано' ) . '<br />' . "\r\n",
  '<img src="style/icq.gif" alt="" /> ' . ( $m[5] ? $m[5] : 'Не указано' ) . '</div>';
 }
 else // Если просто пишем
 {
  echo '<div class="top"><a href="?help">Помощь</a></div>' . "\r\n",
  '<div class="a"><form action="?add" method="post"><fieldset>' . "\r\n",
  'Текст: [' . Q_TEXT . ']<br /><textarea name="text" cols="15" rows="2" class="texta"></textarea><br /><input type="checkbox" name="tr_text" /> Транслит<br />' . "\r\n",
  '<input type="submit" name="send" value="Написать" class="submit" /></fieldset></form></div>';
 }

 echo "\r\n" . '<div class="bottom"><a href="./">В гостевую</a> • <a href="?exit">Выход!</a></div>';
}
elseif( isset($_GET['edit']) ) // Страница редактирования данных юзера
{
 $message = file('data/message.dat');
 $_GET['id'] = ( isset($_GET['id']) ? (int) $_GET['id'] : '' );

 if( !array_key_exists($_GET['id'], $message) )
 {
  exit('Нет сообщения с таким ID\'ом.');
 }

 $m = explode('|', rtrim($message[$_GET['id']]));

 include('system/func_not_active.inc.php');

 $error = '';

 if( isset($_POST['send']) )
 {
  $_POST['name'] = ( empty($_POST['name']) ? '' : clean($_POST['name'], Q_NAME) );
  $_POST['email'] = ( empty($_POST['email']) ? '' : clean($_POST['email'], 20) );
  $_POST['icq'] = ( empty($_POST['icq']) ? '' : clean($_POST['icq'], 10) );
  $_POST['text'] = ( empty($_POST['text']) ? '' : clean($_POST['text'], Q_TEXT) );

  if( !$_POST['name'] )
  {
   $error.= '<div>- Вы не ввели имя.</div>';
  }
  elseif( !preg_match('/[;,~!:@&\.\?\/\[\]\(\)\*\+\-=еёа-яa-z0-9]+/iu', $_POST['name']) )
  {
   $error.= '<div>- В имени обнаружены недопустимые символы.</div>';
  }

  if( $_POST['email'] && !preg_match('/^~?[\.\-a-zA-Z_]+@[\.\-a-zA-Z]+$/', $_POST['email']) )
  {
   $error.= '<div>- Вы ввели некорректный E-mail адрес.</div>';
  }

  if( $_POST['icq'] && !preg_match('/^~?[0-9]+$/', $_POST['icq']) )
  {
   $error.= '<div>- ICQ может содержать только цифры.</div>';
  }

  if( !$_POST['text'] )
  {
   $error.= '<div>- Вы не ввели текст.</div>';
  }

  if( !$error )
  {
   // Обрабатываем

   $_POST['text'] = bbcodesmile(str_replace("\r\n", '<br/>', $_POST['text']));

   // Транслитируем

   if( isset($_POST['tr_name']) )
   {
    $_POST['name'] = translate($_POST['name']);
   }

   if( isset($_POST['tr_text']) )
   {
    $_POST['text'] = translate($_POST['text']);
   }

   foreach( $admin as $v )
   {
    $admin_name[] = strtok($v, '|');
   }

   // Записываем сообщение в файл

   $m[0] = ( in_array($_POST['name'], $admin_name) ? 'admin' : 'user' );
   $m[1] = & $_POST['name'];
   $m[4] = & $_POST['email'];
   $m[5] = & $_POST['icq'];
   $m[9] = & $_POST['text'];
   $message[$_GET['id']] = implode('|',  $m) . "\r\n";

   puts('data/message.dat', implode($message), 'w');

   header('Location: ' . PATH . ( SID ? '?' . SID : '' ));
   exit;
  }
 }

 // Шапка

 echo $header . '<div class="top">Редактирование сообщения</div>' . "\r\n";

 // Если появились ошибки, выводим

 if( $error )
 {
  echo '<div class="b"><span class="red"><strong>Ошибка!</strong></span><br />' . $error . '</div>' . "\r\n";
 }

 // Форма ввода

 echo '<div class="a"><form action="?edit&amp;id=' . $_GET['id'] . '" method="post"><fieldset>' . "\r\n",
 'Имя: [' . Q_NAME . ']<br /><input type="text" name="name" value="' . ( $error ? $_POST['name'] : $m[1] ) . '" maxlength="' . Q_NAME . '" size="15" class="texta" /><br /><input type="checkbox" name="tr_name" />Транслит<br />' . "\r\n",
 'Email: [20]<br /><input type="text" name="email" value="' . ( $error ? $_POST['email'] : $m[4] ) . '" maxlength="20" size="15" class="text" /><br />' . "\r\n",
 'ICQ: [10]<br /><input type="text" name="icq" value="' . ( $error ? $_POST['icq'] : $m[5] ) . '" maxlength="9" size="15" class="text" /><br />' . "\r\n",
 'Текст: [' . Q_TEXT . ']<br /><textarea name="text" cols="15" rows="2" class="texta">' . ( $error ? $_POST['text'] : edittext($m[9]) ) . '</textarea><br /><input type="checkbox" name="tr_text" />Транслит<br />' . "\r\n",
 '<input type="submit" name="send" value="Сохранить" class="submit" />' . "\r\n",
 '</fieldset></form></div>' . "\r\n",
 '<div class="bottom"><a href="?add&amp;id=' . $_GET['id'] . '">Назад</a> • <a href="./">В гостевую</a> • <a href="?exit">Выход!</a></div>';
}
elseif( isset($_GET['ban']) ) // Страница с списком забаненых
{
 $ban = file('data/ban.dat');

 if( isset($_REQUEST['send']) )
 {
  // Выборочное удаление заблокированых

  if( !empty($_POST['id']) && is_array($_POST['id']) )
  {
   puts('data/ban.dat', implode(array_diff_key($ban, array_flip($_POST['id']))), 'w');

   header('Location: ' . PATH . '?ban&page=' . ( isset($_POST['back']) ? (int) $_POST['back'] : 1 ) . ( SID ? '&' . SID : '' ));
   exit;
  }

  // Полная очистка заблокированых

  if( isset($_GET['clear']) )
  {
   puts('data/ban.dat', '', 'w');

   header('Location: ' . PATH . '?ban' . ( SID ? '&' . SID : '' ));
   exit;
  }
 }

 $all = count($ban);
 $_GET['page'] = ( isset($_GET['page']) ? (int) $_GET['page'] : 1 );
 $num_pages = ceil($all / Q_PBAN);
 $start = $_GET['page'] * Q_PBAN - Q_PBAN;

 if( $_GET['page'] > $num_pages || $_GET['page'] < 1 )
 {
  $_GET['page'] = 1;
  $start = 0;
 }

 // Шапка

 echo $header . '<div class="top">Банлист [' . $all . ']</div>' . "\r\n";

 // Выводим

 if( $all )
 {
  echo '<form action="?ban" method="post"><fieldset><input type="hidden" name="back" value="' . $_GET['page'] . '" />' . "\r\n";

  for( $i = $all - $start - 1; $i >= $all - $start - Q_PBAN && isset($ban[$i]); $i-- )
  {
   $b = explode('|', rtrim($ban[$i]));

   echo '<div class="' . ( $i % 2 == 0 ? 'a' : 'b' ) . '">';

   if( $b[0] == 1 ) // Если IP+UA
   {
    echo $b[1] . '/' . strtok($b[2], '/') . '<br />';
   }
   elseif( $b[0] == 2 ) // Если Cookie
   {
    echo 'Cookie ID<br />';
   }
   else // Иначе IP
   {
    echo $b[1] . '<br />';
   }

   echo '<input type="checkbox" name="id[]" value="' . $i . '" /></div>' . "\r\n";
  }

  // Навигация

  echo '<div class="bottom">' . ( $num_pages >= 10 ? '<a href="?go&amp;back=' . $_GET['page'] . '">Стр.</a>' : 'Стр.' );

  for( $pr = '', $i = 1; $i <= $num_pages; $i++ )
  {
   echo $pr = (($i == 1 || $i == $num_pages || abs($i - $_GET['page']) < 3) ? ($i == $_GET['page'] ? " [$i] " : ' <a href="?ban&amp;page=' . $i . '">' . $i . '</a> ') : (($pr == ' .. ' || $pr == '') ? '' : ' .. '));
  }

  echo '</div>' . "\r\n",
  '<div class="a"><input type="submit" name="send" value="Удалить" class="submit" /> <a href="?ban&amp;send&amp;clear">Очистить</a></div></fieldset></form>' . "\r\n",
  '<div class="bottom';
 }
 else
 {
  echo '<div class="a">Список заблокированных пуст.</div>' . "\r\n",
  '<div class="bottom">Стр. [1] • ';
 }

 echo '<a href="./">В гостевую</a> • <a href="?exit">Выход!</a></div>';
}
elseif( isset($_GET['online']) ) // Страница онлайн
{
 $online = file('data/online.dat');
 $all = count($online);
 $_GET['page'] = ( isset($_GET['page']) ? (int) $_GET['page'] : 1 );
 $num_pages = ceil($all / Q_PONLINE);
 $start = $_GET['page'] * Q_PONLINE - Q_PONLINE;

 // Проверка номера страницы

 if( $_GET['page'] > $num_pages || $_GET['page'] < 1 )
 {
  $_GET['page'] = 1;
  $start = 0;
 }

 echo $header . '<div class="top">Кто здесь? [' . $all . ']</div>' . "\r\n";

 // Выводим

 for( $i = $all - $start - 1; $i >= $all - $start - Q_PONLINE && isset($online[$i]); $i-- )
 {
  $o = explode('|', rtrim($online[$i]));
  echo '<div class="' . ( $i % 2 == 0 ? 'a' : 'b' ) . '">' . ( $o[1] ? '<strong>' . $o[1] . '</strong>' : 'Неизвестно' ) . '<br />' .  strtok($o[2], '/') . ', ' . $o[3] . '</div>' . "\r\n";
 }

 // Навигация

 echo '<div class="bottom">' . ( $num_pages >= 10 ? '<a href="?go&amp;back=' . $_GET['page'] . '">Стр.</a> ' : 'Стр. ' );

 for( $pr = '', $i = 1 ; $i <= $num_pages ; $i++ )
 {
  echo $pr = (($i == 1 || $i == $num_pages || abs($i - $_GET['page']) < 3) ? ($i == $_GET['page'] ? " [$i] " : ' <a href="?online&amp;page=' . $i . '">' . $i . '</a> ') : (($pr == ' .. ' || $pr == '') ? '' : ' .. '));
 }

 echo ' • <a href="./">В гостевую</a> • <a href="?exit">Выход!</a></div>';
}
elseif( isset($_GET['help']) ) // Страница помощи
{
 $id_back = ( isset($_GET['id'], $_GET['back']) ? '&amp;id=' . (int) $_GET['id'] . '&amp;back=' . (int) $_GET['back'] : '' );

 echo $header;

 if( isset($_GET['smile']) )
 {
  $smile = array_diff(array_map(create_function('$v', 'return substr($v, 0, -4);'), scandir('smile/')), array(''));
  rsort($smile);
  $all = count($smile);
  $_GET['page'] = ( isset($_GET['page']) ? (int) $_GET['page'] : 1 );
  $num_pages = ceil($all / Q_PSMILE);
  $start = $_GET['page'] * Q_PSMILE - Q_PSMILE;

  // Проверка номера страницы

  if( $_GET['page'] > $num_pages || $_GET['page'] < 1 )
  {
   $_GET['page'] = 1;
   $start = 0;
  }

  echo '<div class="top">Смайлы</div>' . "\r\n";

  // Выводим

  if( $all )
  {
   echo '<div class="a">' . "\r\n";

   for( $i = $all - $start - 1; $i >= $all - $start - Q_PSMILE && isset($smile[$i]); $i-- )
   {
    echo ':' . $smile[$i] . ': <img src="smile/' . $smile[$i] . '.gif" alt=":' . $smile[$i] . ':" /><br />' . "\r\n";
   }

   echo '</div>' . "\r\n";

   // Навигация

   echo '<div class="bottom">' . ( $num_pages >= 10 ? '<a href="?go&amp;back=' . $_GET['page'] . '">Стр.</a> ' : 'Стр. ' );

   for( $pr = '', $i = 1; $i <= $num_pages; $i++ )
   {
    echo $pr = (($i == 1 || $i == $num_pages || abs($i - $_GET['page']) < 3) ? ($i == $_GET['page'] ? " [$i] " : ' <a href="?help&amp;smile' . $id_back . '&amp;page=' . $i . '">' . $i . '</a> ') : (($pr == ' .. ' || $pr == '') ? '' : ' .. '));
   }
  }
  else
  {
   echo '<div class="a">Смайлов нет.</div>' . "\r\n",
   '<div class="bottom">Стр. [1]';
  }

  echo ' • <a href="?help' . $id_back . '">Назад</a> • <a href="./">В гостевую</a> • <a href="?exit">Выход!</a></div>';
 }
 elseif( isset($_GET['bbcode']) )
 {
  echo '<div class="top">ББ коды</div><div class="a">'.file_get_contents('data/bbcode.dat').'</div>
        <div class="bottom"><a href="?help' . $id_back . '">Назад</a> • <a href="./">В гостевую</a> • <a href="?exit">Выход!</a></div>';
 }
 elseif( isset($_GET['translate']) )
 {
  echo '<div class="top">Правила транслита</div><div class="a">'.file_get_contents('data/translit.dat').'</div>
        <div class="bottom"><a href="?help' . $id_back . '">Назад</a> • <a href="./">В гостевую</a> • <a href="?exit">Выход!</a></div>';
 }
 else
 {
  echo '<div class="top">Раздел помощи</div>' . "\r\n",
  '<div class="a">' . "\r\n",
  '• <a href="?help&amp;smile' . $id_back . '">Смайлы</a><br />' . "\r\n",
  '• <a href="?help&amp;bbcode' . $id_back . '">BB коды</a><br />' . "\r\n",
  '• <a href="?help&amp;translate' . $id_back . '">Правила транслита</a>' . "\r\n",
  '</div>' . "\r\n",
  '<div class="bottom"><a href="?add' . $id_back . '">Назад</a> • <a href="./">В гостевую</a> • <a href="?exit">Выход!</a></div>';
 }
}
elseif( isset($_GET['go']) ) // Страница перехода на страницу
{
 echo $header . '<div class="top">Перейти на страницу</div>' . "\r\n",
 '<div class="a"><form action="" method="get"><fieldset>' . "\r\n",
 'Стр. <input type="text" name="page" size="4" class="texta" />' . "\r\n",
 '<input type="submit" value="Go" class="submit" />' . "\r\n",
 '</fieldset></form></div>' . "\r\n",
 '<div class="bottom"><a href="?page=' . ( isset($_GET['back']) ? (int) $_GET['back'] : 1 ) . '">Назад</a> • <a href="?exit">Выход!</a></div>';
}
elseif( isset($_GET['site']) )
{
 $_GET['site'] = str_replace('&amp;', '&', clean($_GET['site'], 500));

 echo $header . '<div class="top">Перейти</div>' . "\r\n",
 '<div class="a"><a href="' . $_GET['site'] . '">' . $_GET['site'] . '</a></div>' . "\r\n",
 '<div class="bottom"><a href="?page=' . ( isset($_GET['back']) ? (int) $_GET['back'] : 1 ) . '">Назад</a> • <a href="/">На главную</a></div>';
}
elseif(isset($_GET['antimat'])){
    $page=isset($_GET['page'])?abs(intval($_GET['page'])):0;
 echo $header.'<div class="top">Антимат</div>';
    $file=file('data/antimat.dat');
    $total=count($file);
    $pages=ceil($total/15);
    if($page<1 || $page>$pages)
        $page=1;
    $start=($page-1)*15;
    $finish=$start+15;
    if($finish>$total)
        $finish=$total;
    for($i=$start; $i<$finish; $i++){
        $exp=explode('|', $file[$i]);
        echo '<div class="'.($i%2?'a':'b').'">'.htmlentities($exp[0], ENT_QUOTES, "UTF-8").' [<a href="?antimatdel&amp;id='.$i.'">Уд</a>]</div>';
    }
    echo '<div class="bottom">';
    if($pages>1){
        if($page>1)
            echo '<a href="?antimat&amp;page=1">1</a> | ';
        if($page-1>2)
            echo '... | ';
        if($page-1>1)
            echo '<a href="?antimat&amp;page='.($page-1).'">'.($page-1).'</a> | ';
        echo '<b>['.$page.']</b> | ';
        if($page+1<$pages)
            echo '<a href="?antimat&amp;page='.($page+1).'">'.($page+1).'</a> | ';
        if($page+2<$pages)
            echo '... | ';
        if($page<$pages)
            echo '<a href="?antimat&amp;page='.$pages.'">'.$pages.'</a>';
    }
    echo '</div>';

    echo '
        <div class="a">
        <form action="?antimatadd" method="post">
            Добавить новое:<br />
            <input name="text" size="40" value="" maxlength="40" /> <input type="submit" name="submit" value="Добавить" />
        </form>
        </div>
        <div class="bottom"><a href="?page=1">Назад</a> • <a href="/">На главную</a></div>';
}
elseif(isset($_GET['antimatadd'])){
    echo $header.'<div class="top">Антимат</div>';
    $text=isset($_POST['text'])?trim($_POST['text']):'';
    $error=false;
    if(mb_strlen($text, 'UTF-8')<3 || mb_strlen($text, 'UTF-8')>50){
        echo '<div class="a">Текст должен содержать от 3 до 50 символов!</div>';
        $error=true;
    }

    $file=file('data/antimat.dat');
    foreach($file as $key=>$val){
        $exp=explode('|', $val);
        if($exp[0]==$text){
            echo '<div class="a">Такое слово уже есть!</div>';
            $error=true;
        }
    }
    if(!$error){
        $f=fopen('data/antimat.dat', 'a+');
        fputs($f, $text."|\r\n");
        fclose($f);
        echo '<div class="a">Сообщение добавлено</div>';
    }

 echo '<div class="bottom"><a href="?page=1">Назад</a> • <a href="?antimat">Антимат</a> • <a href="/">На главную</a></div>';
}
elseif(isset($_GET['antimatdel'])){
    echo $header.'<div class="top">Антимат</div>';
    $id=isset($_GET['id'])?trim($_GET['id']):-1;
    $file=file('data/antimat.dat');
    $f=fopen('data/antimat.dat', 'w+');
    foreach($file as $key=>$val){
        if($key!=$id)
            fputs($f, $val);
    }
    fclose($f);
    echo '<div class="a">Сообщение удалено</div>';
 echo '<div class="bottom"><a href="?page=1">Назад</a> • <a href="?antimat">Антимат</a> • <a href="/">На главную</a></div>';
}
elseif(isset($_GET['news'])){
    echo $header.'<div class="top">Новость</div>';

    if(isset($_POST['submit'])){
        $text=isset($_POST['text'])?trim($_POST['text']):'';
        if(mb_strlen($text, 'UTF-8')>1000){
            echo '<div class="a">Новость может содержать до 1000 символов!</div>';
        }
        else{
            file_put_contents('data/news.dat', $text);
            echo '<div class="b">Новость изменена</div>';
        }
    }
    else{
        $text=file_get_contents('data/news.dat');
    }
    echo '
        <div class="a">
            <form action="?news" method="post">
                <textarea name="text" rows="4" cols="50">'.htmlentities($text, ENT_QUOTES, "UTF-8").'</textarea><br />
                <input type="submit" name="submit" value="Сохранить" />
            </form>
        </div>
    ';
 echo '<div class="bottom"><a href="?page=1">Назад</a> • <a href="/">На главную</a></div>';
}
elseif(isset($_GET['edithelp'])){
    echo $header.'<div class="top">Раздел помощи</div>';
    if(isset($_POST['submit'])){
        $text=isset($_POST['text'])?trim($_POST['text']):'';
        file_put_contents('data/news.dat', $text);
        echo '<div class="b">Раздел помощи изменен</div>';
    }
    else{
        $text=file_get_contents('data/help.dat');
    }
    echo '
        <div class="a">
            <form action="?edithelp" method="post">
                <textarea name="text" rows="4" cols="50">'.htmlentities($text, ENT_QUOTES, "UTF-8").'</textarea><br />
                <input type="submit" name="submit" value="Сохранить" />
            </form>
        </div>
    ';
 echo '<div class="bottom"><a href="?page=1">Назад</a> • <a href="/">На главную</a></div>';
}
elseif(isset($_GET['editbbcode'])){
    echo $header.'<div class="top">BB коды</div>';

    if(isset($_POST['submit'])){
        $text=isset($_POST['text'])?trim($_POST['text']):'';
        file_put_contents('data/bbcode.dat', $text);
        echo '<div class="b">Новость изменена</div>';
    }
    else{
        $text=file_get_contents('data/bbcode.dat');
    }
    echo '
        <div class="a">
            <form action="?editbbcode" method="post">
                <textarea name="text" rows="4" cols="50">'.htmlentities($text, ENT_QUOTES, "UTF-8").'</textarea><br />
                <input type="submit" name="submit" value="Сохранить" />
            </form>
        </div>
    ';
 echo '<div class="bottom"><a href="?page=1">Назад</a> • <a href="/">На главную</a></div>';
}
elseif(isset($_GET['edittranslit'])){
    echo $header.'<div class="top">Правила транслита</div>';
    if(isset($_POST['submit'])){
        $text=isset($_POST['text'])?trim($_POST['text']):'';
        file_put_contents('data/translit.dat', $text);
        echo '<div class="b">Новость изменена</div>';
    }
    else{
        $text=file_get_contents('data/translit.dat');
    }
    echo '
        <div class="a">
            <form action="?edittranslit" method="post">
                <textarea name="text" rows="4" cols="50">'.htmlentities($text, ENT_QUOTES, "UTF-8").'</textarea><br />
                <input type="submit" name="submit" value="Сохранить" />
            </form>
        </div>
    ';
 echo '<div class="bottom"><a href="?page=1">Назад</a> • <a href="/">На главную</a></div>';
}
else // Главная страница
{
 $message = file('data/message.dat');

 if( isset($_REQUEST['send']) )
 {
  // Баним юзеров и/или удаляем сообщения

  if( !empty($_POST['id']) && !empty($_POST['action']) )
  {
   if( !is_array($_POST['id']) || !is_array($_POST['action']) )
   {
    exit('oops!');
   }

   $ban = file('data/ban.dat');

   // Баним

   $in_ipua = in_array('ipua', $_POST['action']);
   $in_cookie = in_array('cookie', $_POST['action']);
   $in_ip = in_array('ip', $_POST['action']);

   if( $in_ipua || $in_cookie || $in_ip )
   {
    foreach( $_POST['id'] as $v )
    {
     $m = explode('|', $message[intval($v)]);

     if( $in_ipua )
     {
      $ban[] = '1|' . $m[7] . '|' . $m[6] . "\r\n";
     }

     if( $in_cookie && $m[8] )
     {
      $ban[] = '2|' . $m[8] . "|\r\n";
     }

     if( $in_ip )
     {
      $ban[] = '3|' . $m[7] . "|\r\n";
     }
    }

    puts('data/ban.dat', implode(array_unique($ban)), 'w');
   }

   // Удаляем сообщение(я)

   if( in_array('delete', $_POST['action']) )
   {
    puts('data/message.dat', implode(array_diff_key($message, array_flip($_POST['id']))), 'w');
   }

   header('Location: ' . PATH . '?page=' . ( isset($_POST['back']) ? (int) $_POST['back'] : 1 ) . ( SID ? '&' . SID : '' ));
   exit;
  }

  // Удаление всех сообщений

  if( isset($_GET['clear']) )
  {
   puts('data/message.dat', '', 'w');

   header('Location: ' . PATH . ( SID ? '?' . SID : '' ));
   exit;
  }
 }

 $all = count($message);
 $_GET['page'] = isset($_GET['page']) ? (int) $_GET['page'] : 1;
 $num_pages = ceil($all / A_Q_MESSAGE);
 $start = $_GET['page'] * A_Q_MESSAGE - A_Q_MESSAGE;

 if( $_GET['page'] > $num_pages || $_GET['page'] < 1 )
 {
  $_GET['page'] = 1;
  $start = 0;
 }

 // Шапка

 echo $header . '<div class="top"><a href="?add">Добавить сообщение</a></div>' . "\r\n";

 if( $all )
 {
  // Сообщения

  echo '<form action="" method="post"><fieldset><input type="hidden" name="back" value="' . $_GET['page'] . '" />' . "\r\n";

  for( $i = $all - $start - 1; $i >= $all - $start - A_Q_MESSAGE && isset($message[$i]); $i-- )
  {
   $m = explode('|', rtrim($message[$i]));
   echo '<div class="' . ( $i % 2 == 0 ? 'a' : 'b' ) . '"><input type="checkbox" name="id[]" value="' . $i . '" /> <span class="' . $m[0] . '"><strong><a href="?add&amp;id=' . $i . '&amp;back=' . $_GET['page'] . '">' . $m[1] . '</a></strong></span> <span class="aa">' . today($m[2]) . ', ' . $m[3] . '</span><br /><span class="ab">' . strtok($m[6], '/')  . ', ' . $m[7] . '</span><br />' . $m[9] . ( $m[10] ? '<div class="answer"><span class="red"><strong>Ответ</strong></span> <span class="aa">' . today($m[11]) . ', ' . $m[12] . '</span><br />' . $m[10] . '</div>' : '' ) . '</div>' . "\r\n";
  }

  // Навигация

  echo '<div class="bottom">' . ( $num_pages >= 10 ? '<a href="?go&amp;back=' . $_GET['page'] . '">Стр.</a> ' : 'Стр. ' );

  for( $pr = '', $i = 1 ; $i <= $num_pages ; $i++ )
  {
   echo $pr = (($i == 1 || $i == $num_pages || abs($i - $_GET['page']) < 3) ? ($i == $_GET['page'] ? " [$i] " : ' <a href="./?page=' . $i . '">' . $i . '</a> ') : (($pr == ' .. ' || $pr == '') ? '' : ' .. '));
  }

  echo '</div>' . "\r\n",
  '<div class="a"><select name="action[]" size="1"  multiple="multiple"><option value="delete">Удалить</option><option value="ipua">IP+UA</option><option value="cookie">Cookie</option><option value="ip">IP</option></select><input type="submit" name="send" value="ok" class="submit" /><br />';
 }
 else
 {
  echo '<div class="a">Сообщений нет.</div>' . "\r\n",
  '<div class="bottom">Стр. [1]</div><div class="a">';
 }

    // Админская менюшка

 echo '
        • <a href="?antimat">Антимат</a><br />
        • <a href="?ban">Банлист</a><br />
        • <a href="?news">Новость</a><br />
        • <a href="?edithelp">Раздел помощи</a><br />
        • <a href="?editbbcode">BB коды</a><br />
        • <a href="?edittranslit">Правила транслита</a><br />
        • Кто здесь? <a href="?online">[' . count(file('data/online.dat')) . ']</a>' . ( $all ? '<br />• Сообщений: ' . $all . ' <a href="?send&amp;clear">[Очистить]</a></div></fieldset></form>' : '' ) . '' . "\r\n",
 '<div class="bottom"><a href="?exit">Выход!</a></div>';
}

// Ноги

echo "\r\n" . '<div class="footer">' . COPYRIGHT . '</div>
</body></html>
<!-- ' . round(microtime(true) - ST, 4) . ' -->';
?>